/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.fixup;

import java.util.ArrayList;
import java.util.List;
import oracle.ops.verification.framework.util.VerificationUtil;

public class FixupSessionData {
    private static List<String> m_usedUserIDListForCreation = new ArrayList<String>();
    private static List<String> m_usedGroupIDListForCreation = new ArrayList<String>();

    public static void addIDToUsedUserIDList(String uid) {
        if (VerificationUtil.isStringGood(uid) && !m_usedUserIDListForCreation.contains(uid)) {
            m_usedUserIDListForCreation.add(uid);
        }
    }

    public static void addIDToUsedGroupIDList(String gid) {
        if (VerificationUtil.isStringGood(gid) && !m_usedGroupIDListForCreation.contains(gid)) {
            m_usedGroupIDListForCreation.add(gid);
        }
    }

    public static boolean isUIDAlreadyUsed(String uid) {
        return m_usedUserIDListForCreation.contains(uid);
    }

    public static boolean isGIDAlreadyUsed(String gid) {
        return m_usedGroupIDListForCreation.contains(gid);
    }

    public static void removeUIDFromUsedIDList(String uid) {
        if (VerificationUtil.isStringGood(uid) && m_usedUserIDListForCreation.contains(uid)) {
            m_usedUserIDListForCreation.remove(uid);
        }
    }

    public static void removeGIDFromUsedIDList(String gid) {
        if (VerificationUtil.isStringGood(gid) && m_usedGroupIDListForCreation.contains(gid)) {
            m_usedGroupIDListForCreation.remove(gid);
        }
    }
}

